
clc
clear all
close all
set(0,'defaultTextInterpreter','latex');        % serve a settare i grafici nei plot
set(0,'defaultAxesFontSize',20);
set(0,'defaultAxesFontName','TimesNewRoman');

%% Costanti fisiche
T=293;              % Temperatura assoluta [K]
mu=1.81e-5;         % viscosit` dinamica dell'aria a 20 C [Ns/m^2]
Pa=101325;             % Pressione ambiente [Pa]
b_c=0.5283;         % rapporto critico pressioni per l'aria
Ps=5.1*1e5;           % P di alimentazione valvola
R=287.053;          % Costante dell'aria [J/Kg/K]
psi=0.6855/sqrt(R*T);

rho=Pa/(R*T);       % Densità dell'aria in condizioni normali [kg/m^3]
Kt=sqrt(293/T);      % Coefficiente correttivo della temperatura
cost=1/(24*mu*R*T);
ck=60000/rho;       % per passare da l/min a kg/s

%% Geometria pattino
n_fori=4;           % numero di fori del pattino
dp=1.05e-3;            % diametro del foro di ingresso del pattino 
dn=0.75*1e-3;
d_ratio=dn/dp;
hg=54e-6;           % profondità media della ragnatura
wg=0.16e-3;          % larghezza ragnatura
L=60e-3;            
B=30e-3;
l=45e-3;            
b=20e-3;
lx=(L-l)/2;
ly=(B-b)/2;
S_eqv=1/3*(b*l+L*B+(b*L+l*B)/2);

%% parametri della valvola
dm=6e-3;            % diametro della membrana metallica m
Rm=dm/2;            % raggio della membrana
x_bypass=12*1e-6;        % distanza di bypass (m)

%% Range di lavoro
h_des=20.5;              % meato desiderato in micron
h=h_des*1e-6;          % meato in metri
Fp=[20:1:120];

for i=1:length(Fp)

%1) Calcolo la pressione media p0
p0(i)=Pa+Fp(i)./S_eqv;

%2) Calcolo la pressione p2

af=0.14;
bf=5e-6;
ff=1-af^(bf/h);
p2(i)=(1/ff).*(p0(i)-Pa)+Pa;        % formula empirica ottenuta da prove sperimentali

%3) Calcolo la portata G3
g3(i)=h.^3.*(p0(i).^2-Pa^2)./(12*mu*R*T)*(b/lx+l/ly);
g(i)=g3(i)/n_fori;

heq=(pi*h*dp+hg*wg)/(pi*dp);
Rea(i)=abs(g(i)).*h/(pi*dp*mu*heq);  % Re anulare
cda(i)=1.05*(1-0.3*exp(-0.005*Rea(i)));

% 4) Calcolo ps
% Regula Falsi (Inizializzazione)
iter=1;

%%G3-G2=0   eq. di continuità
f=@(ps) (g3(i)-n_fori*cda(i)*(pi*h*dp+wg*hg)*Kt*psi*ps.*sqrt(1-((p2(i)./ps-b_c)/(1-b_c)).^2))*1e10;
fs=@(ps) (g3(i)-n_fori*cda(i)*(pi*h*dp+wg*hg)*Kt*psi*ps)*1e10;

%  %  Plot Tratto Sonico-Subsonico
%  figure
%  fplot(f,[-Pa Ps],'-','linewidth',4),hold on
%  fplot(fs,[-Pa Ps],'--','linewidth',4),hold on
%  ylabel('$f(p_1)$'),xlabel('$p_{1}\:($Pa$)$')
%  legend('Subsonico','Sonico')
%  grid on, zoom on,


% Regula Falsi (Inizializzazione)
iter=1;
err=10;
%Estremo inferiore (positivo)
pA(iter)=p2(i);
%Subsonico (A)
if p2(i)/pA(iter)<=1
fA(iter)=real(f(pA(iter)));
end
%Sonico (A)
if p2(i)/pA(iter)<=b_c
fA(iter)=real(fs(pA(iter)));
end

%Estremo superiore (negativo)
pB(iter)=Ps;
%Subsonico (B)
if p2(i)/pB(iter)<=1
fB(iter)=real(f(pB(iter)));
end
%Sonico (B)
if p2(i)/pB(iter)<=b_c
fB(iter)=real(fs(pB(iter)));
end

while  iter<50   %err>1e-9
%Nuovo punto (N)
pN(iter)=pB(iter)-fB(iter)*(pA(iter)-pB(iter))/(fA(iter)-fB(iter));  %equazione retta
%Subsonico (N)
if p2(i)/pN(iter)<=1
fN(iter)=real(f(pN(iter)));
end
%Sonico (N)
if p2(i)/pN(iter)<=b_c
fN(iter)=real(fs(pN(iter)));
end

%Valuto il segno della funzione
if fN(iter)>=0
    fA(iter+1)=fN(iter);
    pA(iter+1)=pN(iter);
    pB(iter+1)=pB(iter);
    fB(iter+1)=fB(iter);
elseif fN(iter)<0
    fB(iter+1)=fN(iter);
    pB(iter+1)=pN(iter);
    pA(iter+1)=pA(iter);
    fA(iter+1)=fA(iter);

end

err=abs(fN(iter));
iter=iter+1;

end

P1_id(i)=pN(end);
Err(i)=err(end);

if P1_id(i)>Ps
    P1_id(i)=Ps;
    x_id(i)=0;
end

%%)Calcolo x
Rea_v(i)=abs(g3(i))/(pi*dn*mu);
cda_v(i)=1.05*(1-0.3*exp(-0.005*Rea_v(i)));
%Subsonico 
if P1_id(i)/Ps<=1
x_id(i)=g3(i)/(cda_v(i)*psi*Kt*pi*dn*Ps*sqrt(1-((P1_id(i)./Ps-b_c)/(1-b_c)).^2));
end
%Sonico (N)
if P1_id(i)/Ps<=b_c
x_id(i)=g3(i)/(cda_v(i)*psi*Kt*pi*dn*Ps);
end

end

% 6) Scelta del campo di lavoro

p1_max=b_c*Ps;          % punto in cui l'ugello passa da sonico a subsonico

[differenza ind_x]=min(abs(x_id-x_bypass));
[differenza ind_p2]=min(abs(P1_id-p1_max));
p1_min=P1_id(ind_x);

%Primo punto
x1=x_id(ind_x);
ps1=P1_id(ind_x)-Pa;

%Secondo Punto
x2=x_id(ind_p2);
ps2=P1_id(ind_p2)-Pa;

xn=x1-(x2-x1)/(ps2-ps1)*ps1
kp=(x2-x1)/(ps2-ps1);
km=pi*Rm^2/kp

x(:)=xn+pi*Rm^2*(P1_id-Pa)/km;

%% plot

Ps_leg=round(Ps*1e-5,2);
d_ratio_leg=round(d_ratio,2);

fig=figure(1); 
% set(fig,'Position',get(0,'ScreenSize')) 
plot(P1_id*1e-6,x_id*1e6,'linewidth',4,'MarkerSize',14), grid on, zoom on, hold on
plot(P1_id*1e-6,x*1e6,'ro','linewidth',4,'MarkerSize',14),hold on
xlabel('Pressure $\quad P_{1,id} \quad (MPa)$','interpreter','Latex'),ylabel('Distance $\quad x_{id} \quad(\mu m) $','interpreter','Latex')
for i=1:length(Ps)
    mylegend{i}=['$P_{s}=\:$', num2str(Ps_leg(i)),'$\:bar$'];
end
legend(mylegend,'Location','northwest','FontSize',25,'FontName','Times New Roman','interpreter', 'Latex');
titleText = ['$x_{id}$ vs $P_{1,id}$ \quad con \quad $h_{des} \: = \:$' num2str(round(abs(h_des))) '$\: \mu m$ \quad $ d_{ratio} \: = \:$' num2str(d_ratio_leg)];
title(titleText,'Interpreter','Latex','FontSize',32,'FontName','Times New Roman' );
set(gca,'TickLabelInterpreter','latex','FontSize',32,'FontName','Times New Roman');
xlim([P1_id(1)*1e-6 P1_id(end)*1e-6])


%% salvo h_des, xn, km, p1min, p1max per i modelli successivi 

% h_des=h_des;
% stringa_Ps=['Ps' '=Ps;'];
% stringa_h_des=['h_des' '=h_des;'];
% stringa_d_ratio=['d_ratio' '=d_ratio;'];
% stringa_xid=['xid'  '=x_id;'];
% stringa_P1id=['P1id' '=P1_id;'];
% 
% structure_project=['save h0_project_Ps' num2str(round(abs(Ps*1e-5))) '_h' num2str(round(abs(h_des))) '_dratio' num2str(d_ratio*10) ' h_des' ' d_ratio' ' xid' ' P1id'];
% 
% eval(stringa_Ps)
% eval(stringa_h_des)
% eval(stringa_d_ratio)
% eval(stringa_xid)
% eval(stringa_P1id)
% 
% eval(structure_project)


